/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.busmon.parser;

import com.quantumdata.busmon.parser.DPCDCommandType;
import com.quantumdata.busmon.parser.DPCDMessageType;

public abstract class DPCDMessage {
    private DPCDMessageType aMessageType;
    private DPCDCommandType aCommandType;
    private boolean aHasData = false;
    private byte[] aData = null;
    protected boolean aIsError = false;
    protected boolean aIsMOT = false;
    protected boolean aNative = false;

    public DPCDMessage(DPCDMessageType dPCDMessageType, DPCDCommandType dPCDCommandType, byte[] byArray) {
        this.aMessageType = dPCDMessageType;
        this.aCommandType = dPCDCommandType;
        this.setData(byArray);
        if (this.aCommandType == DPCDCommandType.AUX_RESERVED) {
            this.aIsError = true;
        }
    }

    public DPCDMessage(DPCDMessageType dPCDMessageType, DPCDCommandType dPCDCommandType, byte[] byArray, boolean bl) {
        this(dPCDMessageType, dPCDCommandType, byArray);
        this.aIsMOT = bl;
    }

    public DPCDMessage(DPCDMessageType dPCDMessageType, DPCDCommandType dPCDCommandType) {
        this(dPCDMessageType, dPCDCommandType, null);
    }

    public DPCDMessage(DPCDMessageType dPCDMessageType, DPCDCommandType dPCDCommandType, boolean bl) {
        this(dPCDMessageType, dPCDCommandType, null);
        this.aIsMOT = bl;
    }

    public String getMessageTypeText() {
        String string = "UNDEFINED";
        switch (this.aMessageType) {
            case READ_REQUEST: 
            case WRITE_REQUEST: 
            case STATUS_UPDATE_REQUEST: {
                string = "REQUEST";
                break;
            }
            case REPLY_TO_READ_REQUEST: 
            case REPLY_TO_WRITE_REQUEST: 
            case REPLY_TO_STATUS_UPDATE_REQUEST: {
                string = "REPLY";
                break;
            }
        }
        return string;
    }

    public String getCommandTypeText() {
        String string = "UNDEFINED";
        switch (this.aCommandType) {
            case READ: {
                string = "READ";
                break;
            }
            case WRITE: {
                string = "WRITE";
                break;
            }
            case AUX_ACK: {
                string = "AUX_ACK";
                break;
            }
            case AUX_NACK: {
                string = "AUX_NACK";
                break;
            }
            case AUX_DEFER: {
                string = "AUX_DEFER";
                break;
            }
            case AUX_RESERVED: {
                string = "AUX_RESERVED";
                break;
            }
            case UPDATE: {
                string = "UPDATE";
                break;
            }
        }
        return string;
    }

    public abstract String getDetails();

    public boolean hasData() {
        return this.aHasData;
    }

    public DPCDMessageType getMessageType() {
        return this.aMessageType;
    }

    public DPCDCommandType getCommandType() {
        return this.aCommandType;
    }

    public String getDirection() {
        String string = "UNKNOWN";
        DPCDMessageType dPCDMessageType = this.getMessageType();
        switch (dPCDMessageType) {
            case READ_REQUEST: 
            case WRITE_REQUEST: 
            case STATUS_UPDATE_REQUEST: {
                string = "MSTR -> SLAVE";
                break;
            }
            case REPLY_TO_READ_REQUEST: 
            case REPLY_TO_WRITE_REQUEST: 
            case REPLY_TO_STATUS_UPDATE_REQUEST: {
                string = "SLAVE -> MSTR";
            }
        }
        return string;
    }

    public byte[] getData() {
        return this.aData;
    }

    public boolean getMOT() {
        return this.aIsMOT;
    }

    public boolean isError() {
        return this.aIsError;
    }

    private void setData(byte[] byArray) {
        if (byArray != null) {
            this.aData = new byte[byArray.length];
            for (int i = 0; i < this.aData.length; ++i) {
                this.aData[i] = byArray[i];
            }
            this.aHasData = true;
        }
    }

    public String getDataAsHexString() {
        StringBuffer stringBuffer = new StringBuffer("");
        byte[] byArray = this.getData();
        stringBuffer.append("Data Bytes:  ");
        for (int i = 0; i < byArray.length; ++i) {
            int n = byArray[i] & 0xFF;
            stringBuffer.append("0x" + Integer.toHexString(n));
            if (i == byArray.length - 1) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }

    public boolean isNative() {
        return this.aNative;
    }

    public void setIsNative() {
        this.aNative = true;
    }
}

